# Module: main
# Author: ElSupremo
# Created on: 22.02.2021
# License: GPL v.3 https://www.gnu.org/copyleft/gpl.html

import sys
import logging
import xbmcgui
import xbmc
import xbmcplugin
import xbmcaddon
import json

#import urllib.parse
#from urllib.parse import urlencode, parse_qsl

# Get the plugin url in plugin:// notation.
_url = sys.argv[0]
# Get the plugin handle as an integer number.
_handle = int(sys.argv[1])

addon_id = 'plugin.video.tivustreampro'
selfAddon = xbmcaddon.Addon(id=addon_id)

viewmode=None

PY3 = sys.version_info[0] == 3

if PY3:
    from urllib.parse import urlencode, parse_qsl
else:
    from urlparse import urlparse, parse_qsl
    from urllib import urlencode, quote


def makeRequest(url, hdr=None):
    if PY3:
	    import urllib.request as myRequest
    else:
	    import urllib2 as myRequest

    pwd = selfAddon.getSetting("password")
    version = selfAddon.getAddonInfo("version")
    if hdr is None:
        ua = "TiVuStreamPro@@"+version+"@@"+pwd
        hdr = {"User-Agent" : ua}
    req = myRequest.Request(url, headers=hdr)
    response = myRequest.urlopen(req)
    html = response.read()
    response.close()
    return html

def play_video(path):
    play_item = xbmcgui.ListItem(path=path)
    # Pass the item to the Kodi player.
    xbmcplugin.setResolvedUrl(_handle, True, listitem=play_item)

def getSource():
    startUrl = selfAddon.getSetting("baseUrl")
    strSource = makeRequest(startUrl)
    if strSource is None or strSource == "":
        logging.warning('We failed to get source from '+startUrl)
    else:
        logging.warning('OK SOURCE ')
        jsonToItems(strSource)

def getExternalJson(strPath):
    strSource = makeRequest(strPath)
    jsonToItems(strSource)

def jsonToItems(strJson):
    global viewmode
    dataJson = json.loads(strJson)
    xbmcplugin.setContent(_handle, 'videos')
    try:
        viewmode = dataJson['SetViewMode']
        skin_name = xbmc.getSkinDir()
        logging.warning("setting view mode for "+skin_name+" on "+viewmode)
        #xbmc.executebuiltin("Container.SetViewMode("+viewmode+")")
    except:
        logging.warning('no view mode')
        pass

    for item in dataJson["items"]:
        titolo = "NO TIT"
        thumb = "https://www.andreisfina.it/wp-content/uploads/2018/12/no_image.jpg"
        fanart = "https://www.andreisfina.it/wp-content/uploads/2018/12/no_image.jpg"
        genre = "generic"
        info = ""
        link = ""
        extLink = False
        extLink2 = False
        is_folder = False
        is_yatse = False
        is_chrome = False
        is_enabled = True

        if 'enabled' in item:
            is_enabled = item["enabled"]

        if is_enabled == False:
            continue
        
        if 'title' in item:
            titolo = item["title"]
        
        if 'thumbnail' in item:
            thumb = item["thumbnail"]

        if 'fanart' in item:
            fanart = item["fanart"]

        if 'info' in item:
            info = item["info"]

        if 'genre' in item:
            genre = item["genre"]

        if 'link' in item:
            link = item["link"]

        if 'externallink' in item:
            extLink = True
            is_folder = True
            link = item["externallink"]

        if 'externallink2' in item:
            extLink2 = True
            is_folder = True
            link = item["externallink2"]

        if 'chrome' in item:
            is_chrome = True
            is_folder = True
            link = item["chrome"]

        if 'yatse' in item:
            is_yatse = True
            is_folder = True
            link = item["yatse"]

        list_item = xbmcgui.ListItem(label=titolo)
        list_item.setInfo('video', {'title': titolo,
                                    'genre': genre,
                                    'mediatype': 'video'})
        list_item.setArt({'thumb': thumb, 'icon': thumb, 'fanart': fanart})
        
        url = ""
        if extLink == True:
            url = get_url(action='getExtData', url=link)
        elif extLink2 == True:
            url = get_url(action='getExtData2', url=link)
        elif is_yatse == True:
            list_item.setProperty('IsPlayable', 'true')
            url = get_urlYatse(action='share', type='unresolvedurl', data=link)
        elif is_chrome == True:
            url = get_urlChrome(mode='showSite', stopPlayback='no', kiosk='no', url=link)
        else:
            list_item.setProperty('IsPlayable', 'true')
            url = get_url(action='play', url=link)

        xbmcplugin.addDirectoryItem(_handle, url, list_item, is_folder)
    # Finish creating a virtual folder.
    xbmcplugin.endOfDirectory(_handle)

def get_url(**kwargs):
    return '{0}?{1}'.format(_url, urlencode(kwargs))

def get_urlYatse(**kwargs):
    return '{0}?{1}'.format("plugin://script.yatse.kodi/", urlencode(kwargs))

def get_urlChrome(**kwargs):
    return '{0}?{1}'.format("plugin://plugin.program.browser.launcher/", urlencode(kwargs))

def parameters_string_to_dict(parameters):
    logging.warning("PARAMS ==> " + parameters)
    params = dict(parse_qsl(parameters.split('?')[1]))
    return params

if not sys.argv[2]:
    logging.warning("=== ADDON START ===")
    getSource()
else:
    params = parameters_string_to_dict(sys.argv[2])
    action =  params['action']
    url =  params['url']
    logging.warning("ACTION ==> "+action)
    if action == 'getExtData':
        getExternalJson(url)
    elif action == 'getExtData2':
        keyboard = xbmc.Keyboard('','Insert string')
        keyboard.doModal()
        if not (keyboard.isConfirmed() == False):
            userInput = keyboard.getText()
            strUrl = url + userInput
            getExternalJson(strUrl)
    elif action == 'youtubedl':
        logging.warning("TRY TO RESOLVE URL: "+url)
        urlSolved = youtubeResolve(url)
        play_video(urlSolved)
    elif action == 'play':
        play_video(url)
    else:
        raise ValueError('Invalid paramstring: {0}!'.format(params))

if not viewmode==None:
   logging.warning("setting view mode")
   xbmc.executebuiltin("Container.SetViewMode("+viewmode+")")
